#version 330
#extension GL_EXT_gpu_shader4 : enable
//KIFS experiments 3Mod01.fsh  by  rodgzilla
//https://www.shadertoy.com/view/3sdXDS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define time iTime
#define SPEED 20.

float PI = acos(-1.);

vec3 palette(float x) {
  float wave = sin(3. * time) * 0.5 + 0.5;
  vec3 p = vec3(1, 1, 1);
  vec3 q = vec3(.3, .6, 1);
  vec3 r = vec3(.3, .6, .3);
  vec3 s = vec3(.9, .5, .3);
  
  return p + q * sin(2. * PI * (x * r + s));
}

mat2 rot2d(float a) {
  float c = cos(a), s = sin(a);

  return mat2(c, s, -s, c);
}

vec3 kifs(vec3 p, float s, float tf) {
  float t = tf * time;
  float wave = sin(time * .3) * 0.5 + 0.5;

  for (float i = 0.; i < 4.; i += 1.) {
    p.xy *= rot2d(t + i);
    p.xz *= rot2d(t * 0.6 - i);
    vec3 p2 = p;
    p2.xy *= rot2d(PI / 2.);
    p = mix(abs(p), abs(p2), wave);
    p -= s;
    s *= 0.8;
  }

  return p;
}

float map(vec3 p) {
  float d = 10000.;
  float old_z = p.z;

  p.xy *= rot2d(p.z / 40.);
  vec3 rep = vec3(20);
  p = mod(p, rep) - 0.5 * rep;

  vec3 pc = kifs(p, 1. + .1 * cos(sin(p.x / 300.) + old_z / 100.), .4 + .1 * sin(old_z / 200.));

  d = min(d, length(pc - vec3(0., .5 * sin(time), 0.)) - 1.);

  return d;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
  vec2 uv = vec2(gl_FragCoord.x / iResolution.x, gl_FragCoord.y / iResolution.y);
  uv -= 0.5;
  uv /= vec2(iResolution.y / iResolution.x, 1);

  vec3 ro = vec3(0, 0, -20. + SPEED * time);
  vec3 rd = normalize(vec3(uv, 1));

  float d = 0.;
  int i;
  for (i = 0; i < 100; i++) {
    vec3 p = ro + d * rd;
    float ds = map(p);

    if (ds < 0.01 || ds > 100.) {
      break;
    }

    d += ds / 2.;
  }
  vec3 p = ro + d * rd;
  vec2 e = vec2(0.01, 0);
  vec3 n = normalize(map(p) - vec3(map(p - e.xyy), map(p - e.yxy), map(p - e.yyx)));
  vec3 l = vec3(0, 0, -70. + SPEED * time);
  float dif = dot(n, normalize(l - p));

  vec3 col = vec3(dif * palette(p.z / 5.));
  gl_FragColor = vec4(col, 1.);
}
